% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_bondPricingQuarterlyCoupon.R
\name{pricingQtrlyCpnBond}
\alias{pricingQtrlyCpnBond}
\title{Calculates Present Value or the Price of the Bond paying Quarterly Coupons.}
\usage{
pricingQtrlyCpnBond(qCoupons, times, mv, n, r)
}
\arguments{
\item{qCoupons}{A vector.}

\item{times}{A vector.}

\item{mv}{A number.}

\item{n}{A number.}

\item{r}{A number.}
}
\value{
Input values to five arguments  \code{qCoupons} , \code{times}, \code{mv},\code{n} and \code{r}.
}
\description{
Calculates Present Value or the Price of the Bond paying Quarterly Coupons.
}
\details{
The method  \code{pricingQtrlyCpnBond()} is developed to compute the Price of Bond making quarterly Coupon Payments. So, \code{pricingQtrlyCpnBond()} gives the Price of Bond making quarterly Coupon Payments for values passed to its five arguments. Here, \code{qCoupons} represents the dollar values of all the quarterly coupon payments till maturity, \code{times} is a vector of number of years ranging from 1 to any specified number of quarterly periods till maturity, that is from 1 to times(n * 4), \code{mv} is Maturity Value, \code{n} is number of years till maturity, and \code{r} is annual Market Discount Rate or Required Rate of return. The output is rounded off to two decimal places. The given examples show various ways in which the arguments can be passed to \code{pricingQtrlyCpnBond()}.
}
\examples{
pricingQtrlyCpnBond(qCoupons=c(2,2,2,2,2,2,2,2), times=c(1,2,3,4,5,6,7,8) ,mv=100,n=2,r=0.06)
pricingQtrlyCpnBond(qCoupons=c(2,2,2,2,2,2,2,2), times=c(1:8) ,mv=100,n=2,r=0.06)
pricingQtrlyCpnBond(qCoupons=c(rep(2,8)), times=c(1:8) ,mv=100,n=2,r=0.06)
pricingQtrlyCpnBond(c(rep(2,8)), c(1:8) ,100,2,0.06)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
