% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraecoLatin.R
\name{GraecoLatin}
\alias{GraecoLatin}
\title{Graeco-Latin squares}
\usage{
GraecoLatin(N)
}
\arguments{
\item{N}{any suitable integer N}
}
\value{
Data frame of factor levels for rows, columns and treatment sets
}
\description{
Constructs mutually orthogonal Graeco-Latin squares for the following N:

i) any odd valued N

ii) any prime-power N = p**q where p and q can be  chosen from 
   \tabular{rrrrrrrr}{
   \bold{prime p} \tab                                       \bold{maximum q}\cr
   2 \tab                                                                13\cr
   3 \tab                                                                 8\cr
   5 \tab                                                                 6\cr                                                      
   7 \tab                                                                 5\cr
   11 \tab                                                                4\cr
   13 17 19 23 \tab                                                       3\cr
   29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 \tab                   2\cr
   Any prime >97 \tab                                                     1
   }

iii) any even valued N <= 30 except for 6 or 2
}
\details{
Plans are given for pairs of MOLS classified by rows and columns.
The output is a single data frame of size \eqn{p**q x (r+2)} for the required set of MOLS
with a column for the rows classification, a column for the columns classification and a 
column for each treatment set from the required set of MOLS.

Also see the function \code{MOLS} which will generate complete sets of MOLS for prime-power design sizes.
}
\examples{
X=GraecoLatin(8) 
table(X[,3],X[,4])
X=GraecoLatin(9) 
table(X[,3],X[,4])
X=GraecoLatin(32)
table(X[,3],X[,4])
 
}
\references{
Street, A. P. & Street, D. J. (1987). Combinatorics of Experimental Design, Chapters 6 and 7.
Clarendon Press, Oxford.
}
\seealso{
\code{\link{MOLS}}
}
