% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef.R
\name{fixef}
\alias{fixef}
\title{Extract the fixed-effects estimates}
\usage{
fixef(object, summary = TRUE, probs = c(0.055, 0.945))
}
\arguments{
\item{object}{An object of class \link[=cumhist-class]{cumhist}}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to 89\% credible interval.}
}
\value{
\code{tibble} with values or summary, \code{NULL} if not fixed effects were used.
}
\description{
Extracts models fixed-effect terms for every modeled distribution parameter.
}
\examples{
\donttest{
br_fit <- fit_cumhist(br_singleblock,
                      state = "State",
                      duration = "Duration",
                      fixed_effects = "Time")
fixef(br_fit)
}
}
