% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBatClassification.R
\name{getBatClassification}
\alias{getBatClassification}
\title{Get a BirdScan 'batClassification' table}
\usage{
getBatClassification(dbConnection, dbDriverChar)
}
\arguments{
\item{dbConnection}{a valid  database connection}

\item{dbDriverChar}{dbDriverChar 'SQL Server' The name of the driver. Should
be either 'SQL Server' or 'PostgreSQL'. If 'PostgreSQL', it connects to
cloud.birdradar.com}
}
\value{
A list containing three variables: (1) batClassificationTable: The
'batClassification' database table; (2) classProbabilitiesAndMtrFactors: A
dataframe containing the classification probabilities for all classes for
each object; and (3) availableClasses: the classes used for the
classification of the objects.
}
\description{
gets  the 'rfClasses' table from a 'Birdscan MR1' 'SQL'
database
}
\examples{
\dontrun{
# Set server and database settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"

# Open the connection with the database
# ===========================================================================
  dsn = paste0("driver=", dbDriverChar, ";server=", dbServer,
               ";database=", dbName,
               ";uid=", rstudioapi::askForPassword("Database user"),
               ";pwd=", rstudioapi::askForPassword("Database password"))
  dbConnection = RODBC::odbcDriverConnect(dsn)

rfClassification = getBatClassification(dbConnection, dbDriverChar)
}

}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com};
Birgen Haest, \email{birgen.haest@vogelwarte.ch}
}
