% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2norm.R
\name{estimate_singleThresh_MLE}
\alias{estimate_singleThresh_MLE}
\title{MLE (Single Threshold per Study)}
\usage{
estimate_singleThresh_MLE(n_i, c_i, p_i_obs, use_wols_init = TRUE)
}
\arguments{
\item{n_i}{numeric vector of sample sizes}

\item{c_i}{numeric vector of thresholds}

\item{p_i_obs}{numeric vector of observed proportions above threshold}

\item{use_wols_init}{logical; if \code{TRUE}, uses Weighted OLS estimates
(\code{\link{estimate_singleThresh_WOLS}}) as initial values in \code{optim}.}
}
\value{
A list with \code{mu}, \code{sigma}, \code{method="MLE"}.
}
\description{
Treats the count of "above threshold" in study \eqn{i} as binomial with probability
\eqn{1 - \Phi((c_i - \mu)/\sigma)}. This uses numerical optimization (\code{optim})
to maximize the binomial likelihood. Optionally uses Weighted OLS estimates as starting
values to improve convergence.
}
