% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_ratioCallSpreadPnL.R
\name{ratioCallSpreadPnL}
\alias{ratioCallSpreadPnL}
\title{Calculates per share Profit and Loss at expiration for Ratio Call Spread and draws its graph in the Plots tab.}
\usage{
ratioCallSpreadPnL(
  ST,
  X1L,
  X2H,
  CX1L,
  CX2H,
  hl = 0.8,
  hu = 1.4,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [PnL] at Expiration ($)",
  main = " Ratio Call Spread [ PnL ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2H}{Higher Strike Price or eXercise price.}

\item{CX1L}{Call Premium paid for the bought Call at Lower Strike.}

\item{CX2H}{Call Premium received for the sold Calls at higher Strike.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This strategy consists of a shorting two calls with a higher strike price X2H, and a buying one (or three) calls with a lower strike price X1L. The graph shows that investor or trader is exposed to uncapped risk and can only make a limited reward and therefore an undesirable strategy (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Ratio Call Spread and draw its graph in the Plots tab. EXAMPLES, Shorting two HypoQuill December 27.50 calls at $1.40 and buying HypoQuill December 25 put at $3.20 OR Shorting two HypoQuill December 27.50 calls at $1.90 and buying HypoQuill December 25 put at $3.20. In the first example, trades are net Debit on the Initiation day as Premium paid is more then the premium received. (In this situation, as displayed in the graph, there are two Breakeven points). However, as shown in the second example the trades can be structured to have net credit on initiation. (In this case, as displayed in the graph, there will be only one Breakeven Point). The graph gets displayed in Plots tab.
}
\examples{
ratioCallSpreadPnL(25,25,27.50,3.20,1.40)
ratioCallSpreadPnL(25,25,27.50,3.20,1.90)
ratioCallSpreadPnL(25,25,27.50,3.20,1.60)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
