% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_aShortCallinitialValueV0.R
\name{aShortCallinitialValueV0}
\alias{aShortCallinitialValueV0}
\title{Displays graph of the Initial Value as Net Credit (V0Cr) per share on initiation day for shorting the Call in the Plots tab.}
\usage{
aShortCallinitialValueV0(
  ST,
  X,
  C,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Initial Value [ V0] ($)",
  main = "Short Call / Call Seller V0 [Dr/Cr] "
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium or call price.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
As we know that options involve two parties: the buyer and the seller (sometimes known as the writer); each of whom agrees to do something for the other, either now or later. The buyer, who purchases the derivative, is referred to as the long or the holder because he owns (pr holds) the derivative and holds a long position. The seller is referred to as the short because he holds a short position and has, upon exercise, an obligation to deliver (Chance, 2019).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to display the Initial Value as Net Credit (V0Cr) per share on initiation day for shorting the Call. EXAMPLE, Writing HypoInc December 10 call at $3.00. Here, \code{X} is the exercise price (strike price) of the option, \code{ST} is the price of the underlying at time T, and \code{C} is the price (also called premium) paid by the European Call Buyer to the the Call Seller. For a call Seller there is inflow of cash in the form of premium received for writing the call and hence it is a Net Credit Position that is represented by V0Cr. The graph gets displayed in Plots tab. Horizontal Straight Line on the graph represents that V0Cr is same irrespective of spot price at expiration.
}
\examples{
aShortCallinitialValueV0(10,10,3)
aShortCallinitialValueV0(50,50,3,0.8,1.2)
}
\references{
Chance,D.M.(2019). Basics of Derivative Pricing and Valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 385-453). Wiley Professional Development (P&T). ISBN 9781119593577, https://bookshelf.vitalsource.com/books/9781119593577\cr
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
