% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_coordinates_outOfRange.R
\name{bdc_coordinates_outOfRange}
\alias{bdc_coordinates_outOfRange}
\title{Identify records with out-of-range geographic coordinates}
\usage{
bdc_coordinates_outOfRange(
  data,
  lat = "decimalLatitude",
  lon = "decimalLongitude"
)
}
\arguments{
\item{data}{data.frame. Containing geographical coordinates. Coordinates must
be expressed in decimal degrees and WGS84.}

\item{lat}{character string. The column name with latitude in decimal degree
and in WGS84. Default = "decimalLatitude".}

\item{lon}{character string. The column with longitude in decimal degree and
in WGS84. Default = "decimalLongitude".}
}
\value{
A data.frame containing the column ".coordinates_outOfRange".
Compliant (TRUE) if 'lat' and 'lon' are not out-of-range; otherwise
"FALSE".
}
\description{
This function identifies records with out-of-range coordinates (not between
-90 and 90 for latitude; between -180 and 180 for longitude).
}
\examples{
x <- data.frame(
  decimalLatitude = c(-185.111, -43.34, "", -21.8069444),
  decimalLongitude = c(-45.4, -39.6, -20.5243, -440.9055555)
)

bdc_coordinates_outOfRange(
  data = x,
  lat = "decimalLatitude",
  lon = "decimalLongitude"
)

}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
