% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales.R
\name{scale_bakeoff}
\alias{scale_bakeoff}
\alias{scale_color_bakeoff}
\alias{scale_fill_bakeoff}
\title{Color scale constructor for \strong{bakeoff} colors}
\usage{
scale_color_bakeoff(
  palette = "showstopper",
  discrete = TRUE,
  direction = 1,
  ...
)

scale_fill_bakeoff(
  palette = "showstopper",
  discrete = TRUE,
  direction = 1,
  ...
)
}
\arguments{
\item{palette}{Character name of palette in \code{\link{bakeoff_palette_names}}.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or
not.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1}, the palette will be reversed.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}} or
\code{\link[ggplot2:scale_gradient]{ggplot2::scale_color_gradientn()}}, used respectively when discrete is
\code{TRUE} or \code{FALSE}.}
}
\value{
A function for constructing a color or a fill scale used for ggplot2 graphics.
}
\description{
Color scale constructor for \strong{bakeoff} colors
}
\examples{
if (require('ggplot2')) {

  ggplot(ratings, aes(x = episode, y = viewers_7day, group = series, color = as.factor(series))) +
    geom_line(lwd = 3) +
    theme_minimal() +
    scale_color_bakeoff("finale", guide = "none")
}

}
\concept{colour scales}
