% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{dispersion}
\alias{dispersion}
\title{Extract Values for Dispersion}
\usage{
dispersion(object, quiet = FALSE, original_scale = FALSE)
}
\arguments{
\item{object}{Object of class \code{"bage_mod"},
typically created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{quiet}{Whether to suppress messages.
Default is \code{FALSE}.}

\item{original_scale}{Whether values for
disperson are on the original
scale or the transformed scale.
Default is \code{FALSE}.}
}
\value{
An \link[rvec:rvec]{rvec}
(or \code{NULL} if the model does not
include a dispersion parameter.)
}
\description{
Extract values for the 'dispersion'
parameter from a model object.
}
\section{Fitted vs unfitted models}{


\code{dispersion()} is typically called on a \link[=fit]{fitted}
model. In this case, the values for dispersion are
draws from the posterior distribution.
\code{dispersion()} can, however, be called on an
unfitted model. In this case, the values
are drawn from the prior distribution.
}

\section{Scaling and Normal models}{


Internally, models created with \code{\link[=mod_norm]{mod_norm()}}
are fitted using transformed versions of the
outcome and weights variables. By default, when \code{dispersion()}
is used with these models,
it returns values on the transformed scale.
To instead obtain values on the untransformed
scale, set \code{original_scale} to \code{TRUE}.
}

\examples{
set.seed(0)

## specify model
mod <- mod_pois(injuries ~ age + sex + year,
                data = nzl_injuries,
                exposure = popn)

## prior distribution
mod |>
  dispersion()

## fit model
mod <- mod |>
  fit()

## posterior distribution
mod |>
  dispersion()

## fit normal model
mod <- mod_norm(value ~ age * diag + year,
                data = nld_expenditure,
                weights = 1) |>
  fit()

## values on the transformed scale
mod |>
  dispersion()

## values on the original scale
mod |>
  dispersion(original_scale = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=components]{components()}} Extract values for hyper-parameters,
including dispersion
\item \code{\link[=set_disp]{set_disp()}} Specify a prior for dispersion
}
}
