% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_descriptions.R
\docType{data}
\name{data_parker}
\alias{data_parker}
\title{Full data from Parker et al (2014)}
\format{
An object of class \code{data.frame} with 328 rows and 11 columns.
}
\source{
Parker BJ, Garcia JR, Gerardo NM (2014)
Genetic variation in resistance and fecundity tolerance in a natural
host-pathogen interaction.
Evolution 68: 2421-2429 \href{https://doi.org/10.1111/evo.12418}{doi}

The full dataset is available at Dryad
\url{https://doi.org/10.5061/dryad.24gq7}
}
\usage{
data_parker
}
\value{
A dataframe
\describe{
\item{Genotype}{names of host genotypes}
\item{SD}{Spore Dose, concentration of fungal spores hosts were exposed to
(spores/mm^2)}
\item{Fecundity}{total number of offspring produced by hosts over lifetime}
\item{Sporulation}{'1' visual signs of sporulation at host death,
'0' no signs of sporulation}
\item{Status}{'0' censored, '1' died}
\item{Time}{time of death (days)}
\item{dose}{dose treatments on ordinal scale of 1-3, controls 0}
\item{censored}{'1' censored, '0' died}
\item{d}{death indicator: '1' died, '0' censored}
\item{t}{time of death (days)}
\item{g}{infection treatment indicator; '1' infected, '0' uninfected}
}
}
\description{
Complete data on the survival of adult female aphids exposed or
unexposed to fungal infection.
}
\examples{
head(data_parker)
}
\keyword{datasets}
