% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_freq_results.R
\name{combine_freq_results}
\alias{combine_freq_results}
\title{Combines the frequency estimation results from single TCR clones and dual TCR clones}
\usage{
combine_freq_results(single, dual)
}
\arguments{
\item{single}{Frequency estimation results of single TCR clones (usually from
the first time \code{\link{freq_estimate}} is called)}

\item{dual}{Frequency estimation results of dual TCR-alpha clones}
}
\value{
A data.frame with the same structure as the output of
   \code{\link{freq_estimate}}. If two single "clones" in the \code{single}
   data.frame is represented by a dual clone in \code{dual}, then it is
   removed and replaced with one row represented by the dual clone.
}
\description{
\code{combine_freq_results()} combines the results of the frequency estimation
performed on single TCR clones (from the output of \code{\link{bagpipe}}) and
the frequency estimation performed on dual clones. The code will find the
rows of the single TCR frequency results that are represented by the dual
clones and replace them with the appropriate dual clone entry.
}

