% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_processing.R
\name{make_polyIRT_data}
\alias{make_polyIRT_data}
\title{Converts continuous performance data to polytomous data with 5 categories.}
\usage{
make_polyIRT_data(df, method = 1)
}
\arguments{
\item{df}{The input data in a dataframe or a matrix}

\item{method}{If \code{1}, then the data is an accuracy measure between 0 and 1. If \code{2}, then the performance data is possibly has a bigger range. So we divide it into 5 equal bins to make it polytomous.}
}
\value{
The polytomous data frame.
}
\description{
This function converts continous performance data to polytomous data with 5 categories
}
\examples{
set.seed(1)
x1 <- runif(500)
x2 <- runif(500)
x3 <- runif(500)
x <- cbind(x1, x2, x3)
xout <- make_polyIRT_data(x)

}
