% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_effectiveness_crm.R
\name{algo_effectiveness_crm}
\alias{algo_effectiveness_crm}
\title{Computes the actual and predicted effectiveness of a given algorithm.}
\usage{
algo_effectiveness_crm(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number, for which the goodness of the IRT model is computed.}
}
\value{
A list with the following components:
\item{\code{effective}}{The \code{x,y} coodinates for the actual and predicted effectiveness curves for algorithm \code{num}. }
\item{\code{predictedEff}}{The area under the predicted effectiveness curve. }
\item{\code{actualEff}}{The area under the actual effectiveness curve. }
}
\description{
This function computes the actual and predicted effectiveness of a given algorithm for different tolerance values.
}
\examples{
\donttest{
set.seed(1)
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
max_item <- rep(1,3)
min_item <- rep(0,3)
mod <- cirtmodel(X, max.item=max_item, min.item=min_item)
out <- algo_effectiveness_crm(mod$model, num=1)
out
}
}
