% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_cran_downloads.R
\name{adj_cran_downloads}
\alias{adj_cran_downloads}
\title{Adjusted Cran Downloads}
\usage{
adj_cran_downloads(packages, when, from, to, removeupdatespikes = TRUE,
  numbercomparison = 100, packagequantile = 0.05)
}
\arguments{
\item{packages}{A character vector, the packages to query.}

\item{when}{\code{last-day}, \code{last-week} or \code{last-month}.
If this is given, then \code{from} and \code{to} are ignored.}

\item{from}{Start date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}

\item{to}{End date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}

\item{removeupdatespikes}{Default TRUE. Removes the spike in downloads due to automatic re-downloads
and CRAN mirrors associated with a package update. Replaces value with the median download value across the measurement period.}

\item{numbercomparison}{Default 100. The number of random packages to inspect to determine the minimum number of downloads in any single day.}

\item{packagequantile}{Default 0.05. The quantile defining the "minimum" number of downloads on a single day.}
}
\value{
A data frame of downloads and total downloads by package.
  \item{\code{date}}{Day of the downloads, it is a Date object.}
  \item{\code{package}}{The package. This column is missing if
    all packages were queried.}
  \item{\code{count}}{Raw download count.}
  \item{\code{total_downloads}}{Raw total number of downloads from beginning of measurement period.}
  \item{\code{mindownloads}}{Estimated CRAN-wide automated downloads for that day.}
  \item{\code{updateday}}{TRUE if the package was updated that day, FALSE otherwise.}
  \item{\code{adjusted_downloads}}{Daily download count, adjusted.}
  \item{\code{adjusted_total_downloads}}{Adjusted total number of downloads from beginning of measurement period.}
}
\description{
Removes daily shared downloads amongst CRAN packages and re-download/CRAN mirror spikes associated with
package updates.
}
\examples{

\dontrun{adj_cran_downloads("skpr",from="2017-08-15",to="2017-11-15")
adj_cran_downloads("skpr",when="last-month")
adj_cran_downloads(c("skpr","AlgDesign"),when="last-month")}
}
