% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr-lfdr.R
\name{corr_lfdr}
\alias{corr_lfdr}
\title{Quantifying Information Loss of Adaptive P-Value Thresholding}
\usage{
corr_lfdr(obj, x, pvals, model = NULL, niter_oracle = 100)
}
\arguments{
\item{obj}{an 'adapt' object. Output of \code{\link{adapt}} function}

\item{x}{covariates (i.e. side-information). Should be compatible to \code{models}.}

\item{pvals}{a vector of values in [0, 1]. P-values}

\item{model}{an optional argument. If \code{model = NULL} then the last model in \code{obj$models} is used for fitting the oracle model (i.e. with all p-values revealed). Otherwise it should be an 'adapt_model' object}

\item{niter_oracle}{an positive integer. Number of iterations in EM algorithm}
}
\value{
\itemize{
\item{corr}{a vector of values in [0, 1]. Pearson correlation of oracle local FDR estimate and the estimates within each step. Each value corresponds to an entry of \code{obj$params}}
\item{oracle_lfdr}{a vector of values in [0, 1]. Oracle local FDR estimate}
\item{lfdr}{a matrix of values in [0, 1]. Local FDR estimates within each step.}
\item{alphas}{a vector of values in [0, 1]. The target FDR levels corresponding to each local FDR estimate}
\item{nmasks}{a vector of integers. The number of masked p-values corresponding to each local FDR estimate}
}
}
\description{
\code{corr_lfdr} computes the oracle local FDR estimate, by using revealing all p-values, and computes the Pearson correlation between it and the estimate within each step of \code{adapt}.
}
\examples{
\donttest{
# Load estrogen data
data(estrogen)
pvals <- as.numeric(estrogen$pvals)
x <- data.frame(x = as.numeric(estrogen$ord_high))
dist <- beta_family()

# Subsample the data for convenience
inds <- (x$x <= 5000)
pvals <- pvals[inds]
x <- x[inds,,drop = FALSE]

# Run adapt_glm
library("splines")
formulas <- paste0("ns(x, df = ", 6:10, ")")
res <- adapt_glm(x = x, pvals = pvals, pi_formulas = formulas,
                 mu_formulas = formulas, dist = dist, nfits = 10)

# Run corr_lfdr
obj <- corr_lfdr(res, x, pvals)
obj$corr
}

}
