% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaHuber.R
\name{adaHuber.cov}
\alias{adaHuber.cov}
\title{Adaptive Huber Covariance Estimation}
\usage{
adaHuber.cov(X, epsilon = 1e-04, iteMax = 500)
}
\arguments{
\item{X}{An \eqn{n} by \eqn{p} data matrix.}

\item{epsilon}{(\strong{optional}) The tolerance level in the iterative estimation procedure. The problem is converted to mean estimation, and the stopping rule is the same as \code{adaHuber.mean}. The defalut value is 1e-4.}

\item{iteMax}{(\strong{optional}) Maximum number of iterations. Default is 500.}
}
\value{
A list including the following terms will be returned:
\describe{
\item{\code{means}}{The Huber estimators for column means. A \eqn{p}-dimensional vector.}
\item{\code{cov}}{The Huber estimator for covariance matrix. A \eqn{p} by \eqn{p} matrix.}
}
}
\description{
Adaptive Huber covariance estimator from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\details{
The observed data \eqn{X} is an \eqn{n} by \eqn{p} matrix. The distribution of each entry can be asymmetrix and/or heavy-tailed. The function outputs a robust estimator for the covariance matrix of \eqn{X}. For the input matrix \code{X}, both low-dimension (\eqn{p < n}) and high-dimension (\eqn{p > n}) are allowed.
}
\examples{
n = 100
p = 5
X = matrix(rt(n * p, 3), n, p)
fit.cov = adaHuber.cov(X)
fit.cov$means
fit.cov$cov
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Ke, Y., Minsker, S., Ren, Z., Sun, Q. and Zhou, W.-X. (2019). User-friendly covariance estimation for heavy-tailed distributions. Statis. Sci., 34, 454-471.
}
\seealso{
\code{\link{adaHuber.mean}} for adaptive Huber mean estimation.
}
