% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaHuber.R
\name{adaHuber.reg}
\alias{adaHuber.reg}
\title{Adaptive Huber Regression}
\usage{
adaHuber.reg(
  X,
  Y,
  method = c("standard", "adaptive"),
  epsilon = 1e-04,
  iteMax = 500
)
}
\arguments{
\item{X}{A \eqn{n} by \eqn{p} design matrix. Each row is a vector of observation with \eqn{p} covariates. Number of observations \eqn{n} must be greater than number of covariates \eqn{p}.}

\item{Y}{An \eqn{n}-dimensional response vector.}

\item{method}{(\strong{optional}) A character string specifying the method to calibrate the robustification parameter \eqn{\tau}. Two choices are "standard"(default) and "adaptive". See Wang et al.(2021) for details.}

\item{epsilon}{(\strong{optional}) Tolerance level of the gradient descent algorithm. The iteration will stop when the maximum magnitude of all the elements of the gradient is less than \code{tol}. Default is 1e-04.}

\item{iteMax}{(\strong{optional}) Maximum number of iterations. Default is 500.}
}
\value{
An object containing the following items will be returned:
\describe{
\item{\code{coef}}{A \eqn{(p + 1)}-vector of estimated regression coefficients, including the intercept.}
\item{\code{tau}}{The robustification parameter calibrated by the tuning-free principle.}
\item{\code{iteration}}{Number of iterations until convergence.}
}
}
\description{
Adaptive Huber regression from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\examples{
n = 200
p = 10
beta = rep(1.5, p + 1)
X = matrix(rnorm(n * p), n, p)
err = rt(n, 2)
Y = cbind(1, X) \%*\% beta + err

fit.huber = adaHuber.reg(X, Y, method = "standard")
beta.huber = fit.huber$coef

fit.adahuber = adaHuber.reg(X, Y, method = "adaptive")
beta.adahuber = fit.adahuber$coef
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Sun, Q., Zhou, W.-X. and Fan, J. (2020). Adaptive Huber regression. J. Amer. Statist. Assoc., 115, 254-265.

Wang, L., Zheng, C., Zhou, W. and Zhou, W.-X. (2021). A new principle for tuning-free Huber regression. Stat. Sinica, 31, 2153-2177.
}
