% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATS_Design.R
\name{ATS_Design}
\alias{ATS_Design}
\title{Adaptive Threshold Simon	Design}
\usage{
ATS_Design(n1, n, n1_star, n_star, r1, r, p0, p1, alpha)
}
\arguments{
\item{n1}{The planned number of patients in stage 1}

\item{n}{The planned number of patients in stages 1 and 2}

\item{n1_star}{The actual number of patients in stage 1}

\item{n_star}{The actual total number of patients in stages 1 and 2}

\item{r1}{Original design threshold in stage 1}

\item{r}{Original design threshold in stage 2}

\item{p0}{Unacceptable efficacy rate}

\item{p1}{Desirable efficacy rate}

\item{alpha}{Original type-I error rate}
}
\value{
a data frame includes the Adaptive Threshold Simon Design (ATS Simon)
first stage threshold r1*, second stage threshold r*, actual first stage
patients n1*, actual total sample sizes of the two stages patients n*, updated
type I error constraint alpha(n*), attained type-I error and Power, Average
sample size under null hypothesis EN(p0) and Probability of early termination
under null hypothesis PET(p0).
}
\description{
ATS_Design( ) provides an Adaptive Threshold Simon Design (ATS Simon) method
for Simon’s two-stage design in oncology trials when the realized sample sizes
in the first stage and/or the second stage(s) are different from the planned
sample sizes in the first stage and/or the second stage(s). The Proposed ATS
Simon design aims to adhere to sample sizes of the original design, to that end,
this design updates the original thresholds of (r1, r) in the first and/or
the second stages to satisfy the type I error rate as the original planned
design (note: power will decrease if the realized sample size is smaller than
the original one).
}
\examples{
# Adaptive Threshold Simon Design Case 1
ATS_Design(19, 36, 17, 34, 3, 10, 0.20, 0.40, 0.1)
#                                 r1* r* n1* n* alpha(n*) Type I Power EN(p0) PET(p0)
# Adaptive Threshold Simon Design   3 10  17 34     0.091  0.059 0.847 24.669   0.549

# Adaptive Threshold Simon Design Case 2
ATS_Design(14, 44, 11, 41, 3, 14, 0.25, 0.45, 0.1)
#                                 r1* r* n1* n* alpha(n*) Type I Power EN(p0) PET(p0)
# Adaptive Threshold Simon Design   2 14  11 41     0.088   0.06 0.854 27.344   0.455

}
\references{
Yunhe Liu, & Haitao Pan. (2024). \emph{Clinical Trial Design Methods
for Managing Under- and Over-Enrollment in Simon's Two-Stage Design, Submitted.}
}
