\name{uwham.boot}
\alias{uwham.boot}

\title{
Variance estimation for UWHAM based on block bootstrap
}

\description{
This function implements variance estimation based on block bootstrap for UWHAM estimates of free energies and
expectations.
}

\usage{
uwham.boot(proc.type, block.size, boot.size, seed = 0, 
           label = NULL, logQ, size=NULL, base = NULL, init = NULL, 
           phi = NULL, state = NULL)
}

\arguments{
  \item{proc.type}{Type of simulation, \code{"indep"} for independent chains at the thermodynamic states, 
                   \code{"parallel"} for (synchronous) parallel tempering, or 
                   \code{"serial"} for (single-chain) serial tempering (see the details).}
  \item{block.size}{A vector of length \code{m=sum(size>0)} (or recycled to be so),
             giving possibly different block sizes for the \code{m} sampled thermodynamic states
             if \code{proc.type=} \code{"indep"}, or 
             a scalar (or truncated to the first element), 
             giving a single block size if \code{proc.type="parallel"} or 
             \code{"serial"}.}
  \item{boot.size}{The number of bootstrap replications.}
  \item{seed}{Seed for random number generation.}
  \item{label}{A vector of length \code{N} of labels between \code{1} to \code{M}
          such that \code{label[i]=j} when \code{i}th observation is obtained 
          from \code{j}th thermodynamic state;
          either \code{label} or \code{size} must be provided if \code{proc.type="indep"} or \code{"parallel"};
          \code{label} must be provided but \code{size} is optional if \code{proc.type="serial"}.}
  \item{logQ}{\code{N x M} matrix of log unnormalized densities (such as \eqn{1/kT}
  times negative potential energies), where 
         \code{N} is the total sample size, i.e., \code{sum(size)}, and
         \code{M} is the number of thermodynamic states for which free energies are to be computed;
         the \code{i}th row of \code{logQ} correspond to \code{i}th observations and 
         the \code{j}th column correspond to \code{j}th thermodynamic state.}
  \item{size}{A vector of length \code{M}, giving the individual sample
  sizes for the \code{M} thermodynamic states, ordered as the columns of \code{logQ};
  if \code{NULL}, then \code{label} is required and used to compute \code{size}.}
  \item{base}{The baseline index, between \code{1} to \code{M}, for the
  thermodynamic state (with sample size \code{>0}) whose free energy is set to 0; if \code{NULL}, then 
\code{base} is set to the first index \code{j} such that \code{size[j]>0}.}
  \item{init}{A vector of length \code{M}, giving the initial values of
  the log-normalizing constants (or log of the partition
  functions); if \code{NULL}, then \code{init} is set to the zero vector.}
  \item{phi}{A vector of function values on the pooled sample; if \code{NULL}, no expectation is estimated.}
  \item{state}{A vector of indices for the thermodynamic states under which expectations are to be computed;
if \code{NULL}, no expectation is estimated.} 
}

\value{
  \item{ze}{The vector of averages of estimated free energies over the bootstrap samples, which can differ from the output \code{ze} in \code{\link{uwham}}.}
  \item{ve}{The vector of estimated variances for the output \code{ze} in \code{\link{uwham}}.}
  \item{phi}{The vector of averages of estimated expectations over the bootstrap samples (which can differ from the output \code{phi} in \code{\link{uwham.phi}}), if \code{phi!=NULL} and \code{state!=NULL}.}
  \item{phi.v}{The vector of estimated variances for \code{phi} in \code{\link{uwham.phi}}, if \code{phi!=NULL} and \code{state!=NULL}.}
}

\details{
The use of block bootstrap requires at least two more inputs than \code{\link{uwham}}: the type of simulation \code{proc.type} and the time ordering of the observations. 

If \code{proc.type="indep"}, the data are assumed to be generated by (approximately) independent chains at different thermodynamic states. The observations corresponding to the rows of \code{logQ} are assumed to be ordered by thermodynamic state and by simulation time within each state.
To perform block bootstrap, data blocks are resampled within each thermodynamic state and then pooled to build bootstrap samples.

If \code{proc.type="parallel"}, the data are assumed to be generated by (synchronous) parallel tempering or replica exhanges. Equal sample sizes are required. The observations corresponding to the rows of \code{logQ} are assumed to be ordered by simulation time and then by \emph{either} thermodynamic state (as in the dataset \code{\link{ligand2.soft}}) \emph{or} replica (as in the dataset \code{\link{ligand2.hard}}). The synchronized block bootstrap is implemented such that blocks corresponding to the same time interval are randomly selected from all the thermodynamic states (Tan et al. 2012).

If \code{proc.type="serial"}, the data are assumed to be generated by (single-chain) serial tempering or simulated tempering. The observations corresponding to the rows of \code{logQ} are assumed to be ordered by time. The thermodynamic labels must then be provided in \code{label}. To perform block bootstrap, data blocks are resampled from the entire chain, and the number of observations at each state is re-computed for each bootstrap sample.
}

\references{
Tan, Z., Gallicchio, E., Lapelosa, M., and Levy, R.M. (2012) "Theory of binless multi-state free energy 
estimation with applications to protein-ligand binding," \emph{Journal of Chemical Physics}, 136, 144102.
}

\examples{

#See the examples for uwham().

}


\keyword{free energy}
\keyword{expectation}