% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcor.R
\name{ezcor_partial_cor}
\alias{ezcor_partial_cor}
\title{Run partial correlation}
\usage{
ezcor_partial_cor(
  data = NULL,
  split = FALSE,
  split_var = NULL,
  var1 = NULL,
  var2 = NULL,
  var3 = NULL,
  cor_method = "pearson",
  sig_label = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables}

\item{split}{whether perform correlation grouped by a variable, default is 'FALSE'}

\item{split_var}{a \code{character}, the group variable}

\item{var1}{a \code{character}, the first variable in correlation}

\item{var2}{a \code{character}, the second variable in correlation}

\item{var3}{a \code{character} or \verb{character vector}, the third variable in correlation}

\item{cor_method}{method="pearson" is the default value. The alternatives to be passed to cor are "spearman" and "kendall"}

\item{sig_label}{whether add symbal of significance. P < 0.001,"\emph{\strong{"; P < 0.01,"}"; P < 0.05,"}"; P >=0.05,""}

\item{...}{other arguments passed to methods}
}
\value{
a \code{data.frame}
}
\description{
Run partial correlation
}
\seealso{
\code{\link[ppcor:pcor.test]{ppcor::pcor.test()}} which this function wraps.
}
\author{
Yi Xiong
}
