% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedmajoritygame.R
\name{weightedmajoritygame}
\alias{weightedmajoritygame}
\title{Weighted majority game}
\usage{
weightedmajoritygame(q, w, binary = FALSE)
}
\arguments{
\item{q}{A quota, as a number between 0 and the sum of player weights.}

\item{w}{The player weights, as a vector of non-negative numbers.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the weighted majority game associated with the described situation, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
This function returns the characteristic function of the described weighted majority game.
}
\details{
Given a situation in which a number of agents have to vote for or against a certain measure,
let \eqn{N =\{1,\ldots,n\}} be the set of voters, \eqn{w} be a non-negative vector of voter weights (the weight of each voter is the number of votes or the proportion of total votes they hold),
and \eqn{q \in [0,\sum_{i \in N}w_{i}]} be the quota (the minimum number of votes or the minimum proportion of total votes needed to pass the measure).
The corresponding weighted majority game, \eqn{v}, is defined by
\deqn{v(S)=1 \text{ if } \sum_{i \in S}w_{i} \geqslant q \text{ and } v(S)=0 \text{ otherwise, for each }S\in 2^N.}
}
\examples{
q <- 39
w <- c(rep(7,5),rep(1,10))
weightedmajoritygame(q,w)
}
