% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfectcoregame.R
\name{perfectcoregame}
\alias{perfectcoregame}
\title{Perfect core game}
\usage{
perfectcoregame(n, binary = FALSE)
}
\arguments{
\item{n}{A number of players, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the perfect core game with \code{n} players, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
This function returns the perfect core game with a given number of players.
}
\details{
The perfect core game of \eqn{n} players is defined by \deqn{v_P(S)=s-\sqrt{\frac{s(n-s)}{n-1}}\text{ for all }S\in 2^N,} where \eqn{s=|S|}.
}
\examples{
perfectcoregame(6)
}
\references{
Shapley, L. S. (1971). Cores of convex games. \emph{International Journal of Game Theory}, 1(3), 11-26.
}
