% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coredimension.R
\name{coredimension}
\alias{coredimension}
\title{Core dimension}
\usage{
coredimension(v, binary = FALSE, tol = 1e-12)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
The dimension of the core of \code{v}, as an integer.
}
\description{
Given a game, this function computes the dimension of its core.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\examples{
v1 <- c(rep(0,5),rep(1,4),0,rep(1,3),2,2)
plotcoreset(v1)
coredimension(v1)

v2 <- c(rep(0,5),rep(1,4),0,rep(1,4),2)
plotcoreset(v2)
coredimension(v2)

v3 <- marginalgame(c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10),1)
plotcoreset(v3)
coredimension(v3)

v4 <- c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10)
plotcoreset(v4)
coredimension(v4)
}
\references{
Edgeworth, F. Y. (1881). \emph{Mathematical psychics: An essay on the application of mathematics to the moral sciences}. CK Paul.

Gillies, D. (1953). \emph{Some theorems on n-person games}. PhD thesis, Princeton, University Press Princeton, New Jersey.
}
\seealso{
\link{balancedcheck}, \link{corevertices}, \link{corevertices234}, \link{plotcoreset}, \link{plotcoresets}
}
