% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvels.R
\name{solvels}
\alias{solvels}
\title{Solve linear system}
\usage{
solvels(A, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{A}{The augmented matrix of a linear system.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
This function returns two outputs: \code{solution} and \code{flag}.
If the introduced linear system is inconsistent: \code{flag=-1} and \code{solution=Inf}.
If it is consistent and has infinitely many solutions: \code{flag=0} and \code{solution} returns one of the solutions, as a vector.
If it is consistent and has a unique solution: \code{flag=1} and \code{solution} returns the unique solution, as a vector.
}
\description{
This function classifies and solves the given linear system.
}
\examples{
# Consistent and determinate system:
solvels(matrix(c(1,1,1,6,2,-1,1,3,-1,-1,1,0), byrow=TRUE, nrow = 3, ncol = 4))
# Consistent and indeterminate system:
solvels(matrix(c(1,1,-3,0,2,-1,-3,3,4,1,-9,3), byrow=TRUE, nrow = 3, ncol = 4))
# Inconsistent system:
solvels(matrix(c(-2,1,1,1,1,-2,1,1,1,1,-2,1), byrow=TRUE, nrow = 3, ncol = 4))
}
