% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corevertices.R
\name{corevertices}
\alias{corevertices}
\title{Core vertices}
\usage{
corevertices(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
If the core of \code{v} is non-empty, the core vertices are returned, as a matrix in which each row is a vertex.
}
\description{
Given a game, this function computes its core vertices.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\note{
Function \code{corevertices234} can also compute the core vertices of games with less than five players, but takes a different approach.
}
\examples{
v=c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10)
corevertices(v)

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # cost game
-corevertices(-cost.v) # core vertices of the cost game
}
\references{
Edgeworth, F. Y. (1881). \emph{Mathematical psychics: An essay on the application of mathematics to the moral sciences}. CK Paul.

Gillies, D. (1953). \emph{Some theorems on n-person games}. PhD thesis, Princeton, University Press Princeton, New Jersey.
}
\seealso{
\link{balancedcheck}, \link{corevertices234}, \link{plotcoreset}, \link{plotcoresets}
}
