% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belong2corecheck.R
\name{belong2corecheck}
\alias{belong2corecheck}
\title{Belong to core}
\usage{
belong2corecheck(v, binary = FALSE, x, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{x}{An allocation, as a vector.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if \code{x} belongs to the core of \code{v}, \code{FALSE} otherwise. If \code{instance=TRUE} and \code{x} does not belong to the core of \code{v}, a justification is also provided: if efficiency is violated, \code{not efficient} is returned; if efficiency is not violated, the position (binary order position if \code{binary=TRUE}; lexicographic order position otherwise) of a coalition for which rationality is violated is returned.
}
\description{
This function checks if an allocation belongs to the core of a game.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\examples{
v <- c(0, 0, 0, 2, 1, 4, 6)
a <- c(3, 1, 2) # an allocation for v
b <- c(2, 2, 2) # egalitarian solution for v
belong2corecheck(v = v, binary = TRUE, x = a, instance = TRUE)
belong2corecheck(v = v, binary = FALSE, x = b, instance = TRUE)

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # cost game
cost.x <- c(1,2,2) # core allocation of cost.v
belong2corecheck(v = -cost.v, x = -cost.x)
}
\references{
Gillies, D. (1953). \emph{Some theorems on n-person games}. PhD thesis, Princeton, University Press Princeton, New Jersey.
}
