% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_bary1d.R
\name{gaussbary1d}
\alias{gaussbary1d}
\title{Barycenter of Gaussian Distributions in \eqn{\mathbb{R}}}
\usage{
gaussbary1d(means, vars, weights = NULL, ...)
}
\arguments{
\item{means}{a length-\eqn{n} vector of mean parameters.}

\item{vars}{a length-\eqn{n} vector of variance parameters.}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise, it should be a length-\eqn{n} vector of nonnegative weights.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{maxiter}{maximum number of iterations (default: 496).}
}}
}
\value{
a named list containing \describe{
\item{mean}{mean of the estimated barycenter distribution.}
\item{var}{variance of the estimated barycenter distribution.}
}
}
\description{
Given a collection of Gaussian distributions \eqn{\mathcal{N}(\mu_i, \sigma_i^2)} for \eqn{i=1,\ldots,n}, 
compute the Wasserstein barycenter of order 2. For the barycenter computation of 
variance components, we use a fixed-point algorithm by \insertCite{alvarez_2016_FixedpointApproachBarycenters;textual}{T4transport}.
}
\examples{
#----------------------------------------------------------------------
#                         Two Gaussians
#
# Two Gaussian distributions are parametrized as follows.
# Type 1 : (mean, var) = (-4, 1/4)
# Type 2 : (mean, var) = (+4, 1/4)
#----------------------------------------------------------------------
# GENERATE PARAMETERS
par_mean = c(-4, 4)
par_vars = c(0.25, 0.25)

# COMPUTE THE BARYCENTER OF EQUAL WEIGHTS
gmean = gaussbary1d(par_mean, par_vars)

# QUANTITIES FOR PLOTTING
x_grid  = seq(from=-6, to=6, length.out=200)
y_dist1 = stats::dnorm(x_grid, mean=-4, sd=0.5)
y_dist2 = stats::dnorm(x_grid, mean=+4, sd=0.5)
y_gmean = stats::dnorm(x_grid, mean=gmean$mean, sd=sqrt(gmean$var)) 

# VISUALIZE
opar <- par(no.readonly=TRUE)
plot(x_grid, y_gmean, lwd=2, col="red", type="l",
     main="Barycenter", xlab="x", ylab="density")
lines(x_grid, y_dist1)
lines(x_grid, y_dist2)
par(opar)

}
\references{
\insertAllCited{}
}
\seealso{
[T4transport::gaussbarypd()] for multivariate case.
}
\concept{gaussian}
