% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visiualization.R
\name{plot_SpaCCI_local}
\alias{plot_SpaCCI_local}
\title{Plot SpaCCI Localized Interaction Results}
\usage{
plot_SpaCCI_local(
  Seurat_Object = NULL,
  spatial_coordinates_dataframe = NULL,
  SpaCCI_local_Result_List,
  Ligand_cell_type,
  Receptor_cell_type,
  spot_plot_size,
  specific_LR_pair_name = NULL,
  significant_cutoff = 0.05
)
}
\arguments{
\item{Seurat_Object}{Optional. A Seurat object containing spatial data. If provided, the function will plot the interaction patterns on the tissue image.}

\item{spatial_coordinates_dataframe}{Optional. A data frame containing the spatial coordinates of the spots. The columns should include \code{"Spot_ID"}, \code{"imagerow"}, and \code{"imagecol"}. The row names must be the names of \code{"Spot_ID"}, matching those in the cell type proportion data frame or the gene expression data frame.}

\item{SpaCCI_local_Result_List}{A list containing the results from a SpaCCI local analysis. This list should include \code{dataframelist} and \code{RegionIDs_matrix}, which are the outputs from \code{run_SpaCCI(..., analysis_scale = "local",...)}.}

\item{Ligand_cell_type}{The name of the ligand cell type to plot. This should match the cell type names used in the \code{run_SpaCCI} analysis.}

\item{Receptor_cell_type}{The name of the receptor cell type to plot. This should match the cell type names used in the \code{run_SpaCCI} analysis.}

\item{spot_plot_size}{A numeric value controlling the size of the spots in the plot.}

\item{specific_LR_pair_name}{Optional. The name of a specific ligand-receptor pair to plot. If provided, the plot will focus on this interaction. The name should match those in the \code{SpaCCI_local_Result_List$dataframelist}.}

\item{significant_cutoff}{A numeric value specifying the significance cutoff for the adjusted P-values from the permutation test. Default is \code{0.05}.}
}
\value{
A plot object showing the localized interaction patterns. The plot will be generated using either the Seurat object or the spatial coordinates data frame, depending on the input provided.
}
\description{
This function provides a unified interface to visualize the localized cell-cell interaction patterns inferred by SpaCCI, either using a Seurat object with a spatial image or a spatial coordinates data frame.
}
\examples{
# Plot localized SpaCCI results using Seurat object
library(SpaCCI)
library(dplyr)
data(result_local)
data(result_local_spatial_coords_df)
spatial_coords_df <- result_local_spatial_coords_df
#plot_SpaCCI_local(Seurat_Object = seurat_object,.....)

# Plot localized SpaCCI results using spatial coordinates
plot_SpaCCI_local(spatial_coordinates_dataframe = spatial_coords_df,
                  SpaCCI_local_Result_List = result_local,
                  Ligand_cell_type = "ductal",
                  Receptor_cell_type = "activated_stellate",
                  spot_plot_size = 3)

}
