% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shhr_gg.R
\name{shhr_gg}
\alias{shhr_gg}
\title{Plot of survival, hazard and hazard ratio of two groups as a function of time using ggplot and patchwork}
\usage{
shhr_gg(
  A,
  B,
  main = NULL,
  sub = NULL,
  group_names = c("control", "treatment"),
  lab_time = "Days",
  lab_group = "Group",
  trafo_time = identity,
  colours = palette()[c(1, 3)],
  linetypes = c(1, 3),
  linewidths = c(1.3, 1.3),
  as_list = FALSE
)
}
\arguments{
\item{A}{mixpch object for group 1 (reference)}

\item{B}{mixpch object for group 2}

\item{main}{Title for the overall plot}

\item{sub}{Subtitle for the overall plot}

\item{group_names}{Group Names}

\item{lab_time}{Title for the time axis}

\item{lab_group}{Title group legend}

\item{trafo_time}{Function to transform time}

\item{colours}{vector of two colours}

\item{linetypes}{vector of two linetypes}

\item{linewidths}{vector of two linewidths}

\item{as_list}{return a list of ggplot objects instead of a patchwork object}
}
\value{
a \code{patchwork} object as defined in the patchwork package or a list of
ggplot objects if \code{as_list=TRUE}.
}
\description{
Plot of survival, hazard and hazard ratio of two groups as a function of time using ggplot and patchwork
}
\examples{
\donttest{
library(ggplot2)
library(patchwork)
library(nph)
B <- pchaz(c(0, 10, 100), c(0.1, 0.05))
A <- pchaz(c(0, 100), c(0.1))
shhr_gg(A, B)
shhr_gg(A, B, lab_time="Months", trafo_time=d2m)
}
}
