% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2.R
\name{f2}
\alias{f2}
\title{Function for computing the f2}
\usage{
f2(conc1, conc2)
}
\arguments{
\item{conc1, conc2}{data frames containing the concentrations obtained for each of the two formulations}
}
\value{
a single value for the f2
}
\description{
Function for computing the f2, time points have to be identical.
Validity criteria of the f2 have to be be checked in advance.
See Moellenhoff et al. (2018) <doi:10.1002/sim.7689>
}
\examples{
data(example_data)
conc1<-select(filter(example_data,Group=="1"),-Tablet,-Group)
conc2<-select(filter(example_data,Group=="2"),-Tablet,-Group)
f2(conc1=conc1,conc2=conc2)
}
\references{
Moellenhoff et al. (2018) <doi:10.1002/sim.7689>
}
