% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_beta_methods.R
\name{sb_beta_methods}
\alias{print.sb_beta,}
\alias{summary.sb_beta,}
\alias{print.summary.sb_beta,}
\alias{autoplot.sb_beta,}
\alias{print.sb_beta}
\alias{summary.sb_beta}
\alias{print.summary.sb_beta}
\alias{autoplot.sb_beta}
\title{User-friendly methods for \code{sb_beta()} results}
\usage{
\method{print}{sb_beta}(x, digits = 3, ...)

\method{summary}{sb_beta}(object, ...)

\method{print}{summary.sb_beta}(x, digits = 3, n = 10, ...)

autoplot.sb_beta(object, variables = NULL, ...)
}
\arguments{
\item{x, object}{An object of class \code{sb_beta}.}

\item{digits}{Number of decimal places to display when printing.}

\item{...}{Additional arguments passed on to lower-level methods.}

\item{n}{Number of rows to show from the summary table when printing.}

\item{variables}{Optional character vector of variables to retain in the
plotted output.}
}
\value{
\code{summary.sb_beta()} returns an object of class \code{summary.sb_beta}
containing a tidy data frame of selection frequencies. The plotting and
printing methods are invoked for their side effects and return the input
object invisibly.
}
\description{
These S3 helpers make it easier to inspect and visualise the
correlation-threshold grid returned by \code{\link[=sb_beta]{sb_beta()}}. They surface the stored
attributes, reshape the selection frequencies into tidy summaries, and produce
quick ggplot2 visualisations for interactive use.
}
\examples{
set.seed(42)
sim <- simulation_DATA.beta(n = 50, p = 4, s = 2)
fit <- sb_beta(sim$X, sim$Y, B = 5, step.num = 0.5)
print(fit)
summary(fit)
if (requireNamespace("ggplot2", quietly = TRUE)) {
  autoplot.sb_beta(fit)
}

}
