% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crude_rates.R
\name{crude_rates}
\alias{crude_rates}
\title{Crude Prevalence Calculator}
\usage{
crude_rates(df, Condition, ...)
}
\arguments{
\item{df}{a tidy dataframe in standard Master Patient Index format ie SangerTools::PopHealthData}

\item{Condition}{A Health condition flag denoted by 1 & 0; where 1 denotes the patient being positive for the health condition}

\item{...}{Variables used to standardise by; Must always have Ageband, additional variables are optional}
}
\value{
a tibble with Crude Prevalence Rates(Rate per 1,000) for each value included in ...
}
\description{
Calculate the crude prevalence of a health condition from a Master Patient Index like dataset
}
\examples{
library(SangerTools)
library(dplyr)
health_data <- SangerTools::PopHealthData
glimpse(health_data)
# Generate crude prevalene rate stats
crude_prevalence <- SangerTools::crude_rates(health_data, Diabetes, Locality)
print(crude_prevalence)
}
