% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realdata.R
\docType{data}
\name{realdata_alpha}
\alias{realdata_alpha}
\title{A list of matrices containing value of alpha at each location.}
\format{An object of class \code{list} of length 8.}
\usage{
realdata_alpha
}
\value{
A list of 8 matrices of calculated value of alpha for case and control points.
\describe{
\item{counts_agebysex_state}{Age-by-sex stratification in Connecticut, which is a
matrix with 18 rows and 2 variables: Male, Female. In this dataset the age-by-sex distribution based on the Census for
the following ten age groups: 35-40, 41-45, 46-50, 51-55, 56-60,
61-65, 66-70, 71-75, 76-80, and 81-83.}

\item{prob_case_1}{Value of alpha for cases in case-control study,
     this \eqn{\alpha_1(s)} is matched to controls' age-by-sex proportion}

\item{prob_case_11}{Value of alpha for cases in case-control study,
    this \eqn{\alpha_2(s)} is matched to BRFSS age-by-sex proportion}

\item{prob_case_2}{Value of alpha for cases in CTR, which is a matrix with 1929 rows and 1 variables: \eqn{\alpha_1(s)}.
This \eqn{\alpha_1(s)} in CTR is matched to controls' age-by-sex proportion in case-control study}

\item{prob_case_22}{Value of alpha for cases in CTR, which is a matrix with 1929 rows and 1 variables: \eqn{\alpha_2(s)}.
This \eqn{\alpha_2(s)} in CTR is matched to BRFSS age-by-sex proportion}

\item{prob_cont_1}{Value of alpha for controls in case-control study, which is a matrix with 690 rows and 1 variables:
\eqn{\alpha_1(s)}. A dataset of controls' \eqn{\alpha_1(s)} of its own}

\item{prob_cont_2}{Another Value of alpha for controls in BRFSS data, which is a matrix with 4459 rows and 1 variables:
\eqn{\alpha_2(s)}. A dataset of controls' \eqn{\alpha_2(s)} in BRFSS data of its own}

\item{pwt_cont_2}{Value of weights(sampling probability) for controls in BRFSS data, which is \eqn{\alpha_2^{\star}}
in equation(14) of Huang(2014), a matrix with 4459 rows and 1 variables}
}
}
\description{
A list of matrices containing value of alpha at each location.
}
\examples{
# For example of each matrix, type the command in R: attributes(realdata_alpha)
# to obtain names of 8 matrices in the list:
#"counts_agebysex_state", "prob_case_1", "prob_case_11", "prob_case_2",
#"prob_case_22", "prob_cont_1", "prob_cont_2", "pwt_cont_2".

}
\keyword{datasets}

