% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSpi.R
\name{Drought Index}

\alias{SPIGA}
\alias{SPIML}

\title{Calculation of Standardized Precipitation Index, using the Genetic Algorithm Method (SPIGA) and Maximum Likelihood (SPIML)}
\usage{
SPIGA(Pmon, scale = 3, population = 500, maxIter = 50, plotGA = FALSE, plotCDF = FALSE)

SPIML(Pmon, scale =3)
}
\description{Calculate the standardized precipitation index (SPI) for monitoring drought using the technique of Genetic Algorithm (SPIGA) and Maximum Likelihood (SPIML) of a series of monthly rainfall for different time scales.}

\arguments{
  \item{Pmon}{monthly precipitation series ordered according to time. It is a data frame with columns: year, month, station 1, station 2, etc.}
  \item{scale}{an integer value representing the time scale of analysis. The most common are 1, 3, 6, 9, 12, 48, etc.}
  \item{population}{an integer value that sets the number of population for the use of the technique of Genetic Algorithm.}
  \item{maxIter}{an integer value that sets the maximum number of iterations also called cycles within the concept of Genetic Algorithm.}
  \item{plotGA}{optional, value Boolean default false. Shows the performance versus the number of cycles in the Genetic Algorithm.}
  \item{plotCDF}{optional, value Boolean default false. Shows the cumulative distribution function of each station. The graphics are monthly.}
}

\details{
The \code{SPIGA} and \code{SPIML}, are functions to calculate the SPI using Artificial Intelligence techniques - Genetic Algorithms (GA) and numerical method - Maximum Likelihood (ML) and both provide quantitative results for monitoring DROUGHT. The GA optimize the parameters alpha and beta of the probability function Gamma given by McKee.


The \code{population} parameter must be an integer and balanced value, large values can generate higher time run, ie, high computational effort and small values can influence the accuracy of the results. By \code{plotGA} option and its corresponding graph, you can see the number of cycles to obtain a proper balance of the accuracy of the results and the computational effort.

\subsection{Input data}{
similar to \code{Pm_Pisco}.
\tabular{llllll}{
Year     \tab Mon	\tab st_1	        \tab st_2	        \tab st_3	 \tab st_4 \cr
1981    \tab 1	    \tab 120.25	        \tab 125.25	        \tab 90.55    \tab 150.25\cr
1981    \tab 2	    \tab 145.25	        \tab 140.25	        \tab 120.70    \tab 145.50\cr
1981    \tab 3	    \tab 120.80	        \tab 150.28	        \tab 90.50    \tab 130.40\cr
1981    \tab 4	    \tab 90.25	        \tab 80.25	        \tab 70.52    \tab 120.40\cr
1981    \tab 5	    \tab 50.25	        \tab 58.25	        \tab 60.50    \tab 80.50\cr
1981    \tab 6	    \tab 40.25	        \tab 38.45	        \tab 80.25    \tab 50.40\cr
1981    \tab 7	    \tab 20.25	        \tab 30.69	        \tab 50.40    \tab 40.40\cr
1981    \tab 8	    \tab 1.25	        \tab 8.85	        \tab 10.40    \tab 25.80\cr
1981    \tab 9	    \tab 25.25	        \tab 14.25	        \tab 5.80    \tab 20.80\cr
1981    \tab 10	    \tab 13.25	        \tab 10.23	        \tab 10.50    \tab 30.45\cr
1981    \tab 11	    \tab 50.25	        \tab 40.25	        \tab 30.50    \tab 80.50\cr
1981    \tab 12	    \tab 80.25	        \tab 90.52	        \tab 80.70    \tab 90.40\cr
1982    \tab 1	    \tab 145.80	        \tab 110.25	        \tab 105.40    \tab 120.25\cr
    .    \tab .	    \tab .	            \tab .	            \tab .      \tab .\cr
    .    \tab .	    \tab .	            \tab .	            \tab .      \tab .\cr
    .    \tab .	    \tab .	            \tab .	            \tab .      \tab .\cr
}
}
}

\value{
Functions \code{SPIGA} and \code{SPIML} return values saved in .txt formats (Tabular) and .pdf (graphics). They are located in the working folder of \code{R} [getwd()].
}

\references{
McKee, Thomas B. and Doesken, Nolan J. and Kleist, John. 1993. The relationship of Drought Frequency and Duration to Time Scales. \emph{Eighth Conference on Applied Climatology}

A. Belauneh and J. Adamowski. Standard Precipitation Index Drought Forecasting Using Neural Networks, Wavelet Neural Networks, and Support Vector Regression. \emph{Applied Computational Intelligence and Soft Computing}, http://dx.doi.org/10.1155/2012/794061
%\url{http://}
}

\author{
Iván Arturo Ayala Bizarro <ivan.ayala@unh.edu.pe>

Jessica Zúñiga Mendoza <zumeje@gmail.com>
}

\note{Dependencies: the SPIGA function, depend on the library \code{GA}.}

\seealso{\code{\link{SPIFromParameters}} to calculate the standardized precipitation index, from alpha and beta parameter of the Gamma function.}

\examples{
#### Load data
data(Pm_Pisco)
Pmon<-Pm_Pisco      # dataframe Precipitation
summary(Pm_Pisco)   # view summary
Pmon<-Pm_Pisco[,]

#### Computing SPI with Genetic Algorithms
pob     <-50        # Define population number
iMax    <-10        # Define Max iteration

# Total stations calculation. It may take some time.
#SPIGA(Pmon, scale=3, population=pob, maxIter = iMax, plotGA=TRUE, plotCDF=TRUE)

# station 1 computing
Pmon1<-data.frame(Pmon[,1:2], Pmon$Pm_St1)
SPIGA(Pmon1, scale=3, population=pob, maxIter = iMax)

# station 2 computing
Pmon2<-data.frame(Pmon[,1:2], Pmon$Pm_St2)
SPIGA(Pmon2, scale=3, population=pob, maxIter = iMax)

#### Computing SPI with Maximun Likelihood
SPIML(Pmon, scale=3)
}



