% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSpi.R
\name{Drought Index from Parameters}

\alias{SPIFromParameters}

\title{Calculation of standardized precipitation index from alpha and beta parameter of the Gamma function.}
\usage{
SPIFromParameters(Pmon, scale =3, Param_Alpha, Param_Beta)
}
\description{calculate the standardized precipitation index, from alpha and beta parameter of the Gamma function.}

\arguments{
  \item{Pmon}{monthly precipitation series ordered according to time. It is a data frame with columns: year, month, station 1, station 2, etc.}
  \item{scale}{an integer value representing the time scale of analysis. The most common are 1, 3, 6, 9, 12, 48, etc.}
  \item{Param_Alpha}{data frame monthly data values corresponding to the alpha parameter to the function Gamma.}
  \item{Param_Beta}{data frame monthly data values corresponding to the alpha parameter to the function Gamma.}
}

\details{
Analysis stations are in the columns of dataframe. the apha and beta parameters, are monthly and are in the rows of dataframe.

\subsection{Input data}{
similar to \code{Pm_Pisco}.
\tabular{lllll}{
Mon	\tab st_1	        \tab st_1	        \tab st_2	        \tab st_3 \cr
Jan	\tab 9.584860915	\tab 9.227918987	\tab 10.35269003	\tab 8.433823824\cr
Feb	\tab 13.76378505	\tab 15.02620223	\tab 12.1021093	    \tab 10.85133914\cr
Mar	\tab 26.09112343	\tab 17.41749632	\tab 21.10924889	\tab 23.53649421\cr
Apr	\tab 17.34996675	\tab 17.4451073	    \tab 13.00894394	\tab 16.66595319\cr
May	\tab 9.943259493	\tab 9.46815537	    \tab 9.164645239	\tab 9.455850664\cr
Jun	\tab 5.103175852	\tab 5.041710686	\tab 4.080851346	\tab 5.790986084\cr
Jul	\tab 2.85804336	    \tab 3.042484994	\tab 2.797962575	\tab 2.645188236\cr
Aug	\tab 3.033862506	\tab 3.183267843	\tab 3.435303986	\tab 2.631287947\cr
Sep	\tab 3.815308513	\tab 2.627317533	\tab 3.550365645	\tab 3.66482456\cr
Oct	\tab 7.430925356	\tab 3.956716609	\tab 7.023105167	\tab 7.540706878\cr
Nov	\tab 6.303310502	\tab 5.339943557	\tab 6.358902249	\tab 5.556660824\cr
Dec	\tab 5.84110559	    \tab 5.899534971	\tab 6.581657735	\tab 4.889599504\cr
}
}
}

\value{
return values of standardized precipitation index in .txt formats.
}

\references{
McKee, Thomas B. and Doesken, Nolan J. and Kleist, John. 1993. The relationship of Drought Frecuency and Duration to Time Scales. \emph{Eighth Conference on Applied Climatology}

A. Belauneh and J. Adamowski. Standard Precipitation Index Drought Forecasting Using Neural Networks, Wavelet Neural Networks, and Support Vector Regression. \emph{Applied Computational Intelligence and Soft Computing}, http://dx.doi.org/10.1155/2012/794061
%\url{http://}
}

\author{
Iván Arturo Ayala Bizarro <ivan.ayala@unh.edu.pe>

Jessica Zúñiga Mendoza <zumeje@gmail.com>
}

\examples{
#### Load data
data(Pm_Pisco)
data(alphaGA_SPI3)
data(betaGA_SPI3)

#### Computing SPI with Genetic Algorithms
Pmon<-Pm_Pisco
Param_Alpha <- alphaGA_SPI3
Param_Beta <- betaGA_SPI3
SPIFromParameters(Pmon, scale =3, Param_Alpha, Param_Beta)
}



