% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mams.R
\name{sim.trial}
\alias{sim.trial}
\title{Function to simulate Bayesian seamless multi-arm biomarker-enriched phase
II/III designs}
\usage{
sim.trial(
  median.c,
  hr,
  K,
  L,
  lfu,
  alpha,
  power,
  accrate,
  theta,
  bio.preva,
  FAtime.phase3,
  N.iter
)
}
\arguments{
\item{median.c}{The median survival time for control group}

\item{hr}{Alternative hazard ratio}

\item{K}{Number of biomarkers}

\item{L}{Information fraction in terms of the accumulative events in phase II stage, e.g., K = c(1/4,1/2,1)}

\item{lfu}{Follow-up time}

\item{alpha}{One-sided familywise error rate}

\item{power}{Power}

\item{accrate}{Accrual rate}

\item{theta}{A clinically meaningful treatment effect size defined by clinicians}

\item{bio.preva}{Prevalence of biomarker(s)}

\item{FAtime.phase3}{the study ending time of phase III}

\item{N.iter}{Number of iterations}
}
\value{
sim_trial() returns the nominal type I error rate and calibrated cutoff
points, nominal power under user-defined hypothesis, empirical power under
user-defined number of simulations, the duration of trial(time), the number
of events (num_evs), the number of patients (num_pts) from different stages.
The function can also display the number of events and patients under the
selected subgroup, the distribution of decision zones and the estimated hazard
ratio for the final analysis.
}
\description{
\if{html}{\out{<div class="sourceCode">}}\preformatted{This function finds the required number of events
using a multi-arm multi-stage biomarker-enriched design with time-to-event
endpoints.
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
sim.trial(median.c=12,hr=c(1,1,1,0.6),K=2,L=c(1/4,1/2,1),lfu=0,
          alpha=0.05,power=0.9,accrate=15,theta=log(1.25),
          bio.preva=c(0.4,0.6),FAtime.phase3=48,N.iter=5)
}

}
