\name{Risk-package}
\alias{Risk-package}
\alias{Risk}
\docType{package}
\title{Computes 26 Financial Risk Measures for Any Continuous Distribution}
\description{Computes 26 financial risk measures, including value at risk, expected shortfall due to Artzner et al. (1999) <DOI:10.1007/s10957-011-9968-2>, tail conditional median due to Kou et al. (2013) <DOI:10.1287/moor.1120.0577>, expectiles due to Newey and Powell (1987) <DOI:10.2307/1911031>, beyond value at risk due to Longin (2001) <DOI:10.3905/jod.2001.319161>, expected proportional shortfall due to Belzunce et al. (2012) <DOI:10.1016/j.insmatheco.2012.05.003>, elementary risk measure due to Ahmadi-Javid (2012) <DOI:10.1007/s10957-011-9968-2>, omega due to Shadwick and Keating (2002), sortino ratio due to Rollinger and Hoffman (2013), kappa  due to Kaplan and Knowles  (2004), Wang (1998)'s <DOI:10.1080/10920277.1998.10595708> risk measures, Stone (1973)'s <DOI:10.2307/2978638> risk measures, Luce (1980)'s <DOI:10.1007/BF00135033> risk measures, Sarin (1987)'s <DOI:10.1007/BF00126387> risk measures, Bronshtein and Kurelenkova (2009)'s risk measures.}
\details{
\tabular{ll}{
Package: \tab Risk\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2017-06-05\cr
License: \tab GPL(>=2)
}
financial risk measures
}
\author{Saralees Nadarajah, Stephen Chan

Maintainer: Saralees Nadarajah <Saralees.Nadarajah@manchester.ac.uk>
}
\references{A. Ahmadi-Javid,
Entropic value-at-risk: A new coherent risk measure,
Journal of Optimization Theory and Applications, 155, 2012, 1105-1123
<DOI:10.1007/s10957-011-9968-2>

P. Artzner, F. Delbaen, J. M. Eber and D. Heath,
Coherent measures of risk, Mathematical Finance, 9, 1999, 203-228
<DOI:10.1007/s10957-011-9968-2>

F. Belzunce, J. F. Pinar, J. M. Ruiz and M. A. Sordo,
Comparison of risks based on the expected proportional shortfall,
Insurance: Mathematics and Economics, 51, 2012, 292-302
<DOI:10.1016/j.insmatheco.2012.05.003>

E. Bronshtein and J. Kurelenkova, Complex risk measures in portfolio optimization,
Ufa State Aviation Technical University, Russia, 2009

S. Chan and S. Nadarajah, Risk: An R package for risk measures, submitted

P. D. Kaplan and J. A. Knowles,
Kappa: A generalized downside risk-adjusted performance measure,
Miscellaneous Publication, Morningstar Associates and York Hedge Fund Strategies, 2004

S. Kou, X. Peng and C. C. Heyde,
External risk measures and Basel accords,
Mathematics of Operations Research, 38, 2013, 393-417
<DOI:10.1287/moor.1120.0577>

F. M. Longin,
Beyond the VaR,
Journal of Derivatives,  8, 2001, 36-48
<DOI:10.3905/jod.2001.319161>

R. D. Luce,
Several possible measures of risk,
Theory and Decision, 12, 1980, 217-228
<DOI:10.1007/BF00135033>

W. K. Newey and J. L. Powell,
Asymmetric least squares estimation and testing,
Econometrica, 55, 1987, 819-847
<DOI:10.2307/1911031>

T. Rollinger and S. Hoffman,
Sortino ratio: A better measure of risk,
Risk Management, 2013, 40-42

R. K. Sarin,
Some extensions of Luce's measures of risk,
Theory and Decision, 22, 1987, 125-141
<DOI:10.1007/BF00126387>

W. F. Shadwick and C. Keating,
A universal performance measure,
Journal of  Performance Measurement, 2002

B. K. Stone,
A general class of three-parameter risk measures,
The Journal of Finance, 28, 1973, 675-685
<DOI:10.2307/2978638>

S. Wang,
An actuarial index of the right-tail risk,
North American Actuarial Journal, 2, 1988, 88-101
<DOI:10.1080/10920277.1998.10595708>}
\keyword{package}
