% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hartigan_and_Wong.R
\name{Hartigan_and_Wong}
\alias{Hartigan_and_Wong}
\title{Flexibilization of the Hartigan and Wong algorithm}
\usage{
Hartigan_and_Wong(
  data,
  distance,
  k,
  centers_function,
  init_centers,
  seed = NULL,
  ITER
)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{k}{Number. Number of groups into which we are going to group the different points.}

\item{centers_function}{Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers. With \code{grouping} we mean a list. The list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.}

\item{init_centers}{Function. This function designs how we are going to calculate the initial centers. The input must be the \code{data}, \code{distance} and \code{k} and the output must be a matrix where each row has the center of one group.}

\item{seed}{Number. Number to fix a seed and be able to reproduce your results.}

\item{ITER}{Number. Maximum number of iterations.}
}
\value{
Returns a list with:

\itemize{
  \item centers: the information of the centers updated. Matrix with \code{dim(centers)[1]} centers of \code{dim(centers)[2]} dimensions.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }
}
\description{
This function implements the Hartigan and Wong algorithm (Hartigan and Wong, 1979) without imposing the use of the euclidean distance and without imposing that the centers of the groups are calculated by averaging the points. This function allow the use of  other distances and different ways to calculate the centers of the groups.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
         matrix(runif(20,20,30), nrow = 2, ncol = 10),
         matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5

Hartigan_and_Wong(data,
                 Euclideandistance,
                 k,
                 centers_function_mean,
                 init_centers_random,
                 seed=seed,
                 10)


}
\references{
Hartigan, J. A., & Wong, M. A. (1979). Algorithm AS 136: A k-means clustering algorithm. Journal of the royal statistical society. series c (applied statistics), 28(1), 100-108.
}
