% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_vectors.R
\name{pop_vectors}
\alias{pop_vectors}
\title{Derive a hypothetical set of population vectors corresponding to a
time-series of matrix population models}
\usage{
pop_vectors(A, start = "stable.stage")
}
\arguments{
\item{A}{A list of MPMs (i.e., square population projection matrices).}

\item{start}{Method to derive the first population vector in the series.
Either \code{stable.stage} to use the stable stage distribution of the mean
matrix as the starting vector, \code{uniform} to use a uniform starting
vector (all elements equal), or \code{random} to use a randomly-generated
starting vector. Defaults to the stable stage distribution.}
}
\value{
A list of population vectors
}
\description{
Derive a hypothetical set of population vectors (i.e. population size
distributions across stages) given a time-series of matrix population models
(MPMs), by taking the stable stage distribution of the mean matrix as the
starting vector (or optionally, a uniform or random starting vector), and
deriving subsequent vectors through recursive population projection.
}
\details{
This function is useful for providing population vectors as input to the
\code{\link{perturb_stochastic}} function which calculates stochastic
elasticities given a time-series of matrix population models and
corresponding population vectors, using the method described in Haridas et
al. (2009).
}
\examples{
# generate list of matrices
matA_l <- replicate(5, matrix(runif(9), 3, 3), simplify = FALSE)

# calculate corresponding population vectors
pop_vectors(matA_l)
pop_vectors(matA_l, start = "uniform")
pop_vectors(matA_l, start = "random")

}
\references{
Haridas, C. V., Tuljapurkar, S., & Coulson, T. 2009. Estimating
  stochastic elasticities directly from longitudinal data. Ecology Letters,
  12, 806-812. <doi:10.1111/j.1461-0248.2009.01330.x>
}
\seealso{
Other perturbation analysis: 
\code{\link{perturb_matrix}()},
\code{\link{perturb_stochastic}()},
\code{\link{perturb_trans}()},
\code{\link{perturb_vr}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{perturbation analysis}
