% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.auc.test.r
\name{group.auc.test}
\alias{group.auc.test}
\title{Function to compare AUC across all consecutive categories of an ordinal scale}
\usage{
group.auc.test(outcome,predictor, 
                      groups, cut.off='max.Youden',BR=1)
}
\arguments{
\item{outcome}{The outcome variable indicating the status in the form of a data frame or matrix. 
This variable is typically coded as 0 (positive) and 1 (negative).}

\item{predictor}{A numerical vector of scores used to predict the status of the outcome. This variable 
should be of the same length as the outcome variable (i.e., two variables are 
from the same data set and also of the same number of data rows).}

\item{groups}{A data frame that contains all created indicator variables using the function
group.to.vars () in this package.}

\item{cut.off}{Specification of the criterion used to select the optimal cut score. 
Three options available: (1) 'max.Youden' returns the cut score that maximizes the Youden Index (the default);
(2) 'max.sen' returns the cut score that maximizes the sensitivity; and (3) 'max.spe' returns
the cut score that maximizes the specificity.}

\item{BR}{Base rates or known prevalence. Multiple values can be specified simultaneously. 
By default BR=1.}
}
\value{
A list of two objects: (1) descriptive and classification statistics, and
(2) results of the AUC comparison for each pair of the consecutive categories.
\item{Summary.Stats}{Summary and classification statistics for all participants and
all the consecutive groups. The first row is the results of the entire sample and has a row name of "All", 
followed by results for each pair of the groups specified by group.to.vars (). For example, 
if the first indicator of age is age.40, then the second row of results will have the row name of "age.40" and
includes results for participants with age at or below 40, the third row will have the row name of
"age.40.1" and includes results for those with age beyond 40. \cr
The results include the following statistics: \cr
 * N, the sample size for each category. \cr
 * TP, true positives. \cr
 * FP, false positives. \cr 
 * FN, false negatives.\cr
 * TN, true negatives.\cr
 * Cut.off, the optimal cut score.\cr
 * AUC, Area under the ROC curve.\cr
 * AUC.SE, Standard error of AUC.\cr
 * AUC.low & AUC.up, '95%' confidence interval of AUC. \cr
 * Sensitivity, also true positive rate, y-axis of the ROC.\cr
 * Specificity, also true negative rate. \cr
 * Youden.Index. \cr
 * PPV or positive predictive value for each specified base rate.\cr
 * NPV or negative predictive value for each specified base rate.\cr
 * PPV for the sample.\cr
 * NPV for the sample.\cr
 * FNR, false negative rate, or miss rate.\cr
 * FPR, false positive rate, or fall-out rate.\cr
 * FOR, false omission rate.\cr
 * FDR, false discovery rate.\cr
 * Prevalence.\cr
 * Accuracy.\cr
 * PLR, positive likelihood ratio.\cr
 * NLR, negative likelihood ratio.\cr
 * DOR, Diagnostic odds ratio.}
\item{AUC.test}{Results of the AUC comparison for each pair of the consecutive categories.}
}
\description{
This function computes commonly used classification statistics of a confusion matrix
and compares the area under the curve (AUC) across all consecutive categories of an ordinal variable. 
The function of roc.test () from the pROC package 
(\url{https://cran.r-project.org/package=pROC}) is used for AUC comparison.
}
\examples{
 
#read the example data
data(ROC.data.ex)
#create new binary variables for the ordinal variable
data.new.age<-group.to.vars(ROC.data.ex,
                            ROC.data.ex$age,
                           root.name='age')
#run the function
result.age<-group.auc.test(ROC.data.ex$outcome,ROC.data.ex$predictor, 
                           groups=data.new.age[,5:ncol(data.new.age)],
                           cut.off='max.Youden', BR=1)
#obtain results
result.age$Summary.Stats
result.age$AUC.test
}
