% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{nhanes_vcov}
\alias{nhanes_vcov}
\title{Extract variance/covariance matrix from parameters of svymean}
\usage{
nhanes_vcov(nhanes_data, columns, weights_column = "", filter = "")
}
\arguments{
\item{nhanes_data}{data frame containing NHANES data}

\item{columns}{columns to include in svymean for}

\item{weights_column}{name of the weights column}

\item{filter}{logical expression used to subset the data}
}
\value{
a data frame
}
\description{
Extract variance/covariance matrix from parameters of svymean
}
\examples{

\dontrun{
dat <- nhanes_load_data("PFC_G", "2011-2012", demographics = TRUE)

nhanes_vcov(dat, c("LBXPFOA", "LBXPFOS"))
}

}

