% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal_counterfactual.R
\name{counterfactual}
\alias{counterfactual}
\title{Counterfactual inference via simulation}
\usage{
counterfactual(
  scm,
  situation,
  n,
  target = NULL,
  ifunction = NULL,
  method = NULL,
  returnscm = FALSE,
  control = NULL
)
}
\arguments{
\item{scm}{An SCM object}

\item{situation}{A list or a character string. The list has the following elements:
\itemize{
\item do : NULL or a list containing named elements 'target' and 'ifunction' that
specify the intervention carried out in the situation
\item dolist : NULL or a list of lists containing named elements 'target' and 
'ifunction' that specify the intervention carried out in each parallel world
\item condition : either a string that gives an SQL query ( e.g. "select x,y,z from DATA where" )
or a data.table consisting of the valid rows ( e.g. data.table::data.table( x = 0, y = 0))
\item condition_type : (required only if method == "u_find") A character vector giving the type ("continuous" or "discrete") of every variable in \code{situation$condition}
}}

\item{n}{The number of rows in the data to be simulated}

\item{target}{NULL or a vector of variable names that specify the target
variable(s) of the counterfactual intervention.}

\item{ifunction}{NULL or a list of functions for the counterfactual intervention.}

\item{method}{The simulation method, "u_find", "rejection" or "analytic_linear_gaussian"}

\item{returnscm}{A logical, should the internally created twin SCM or parallel 
world SCM returned?}

\item{control}{List of parameters to be passed to the simulation method:
\itemize{
\item batchsize: (u_find, rejection) The size of data from n observations are resampled (default n)
\item max_iterations: (u_find) The maximum number of iterations for the binary search (default 50)
\item minu: (u_find) A scalar or a named list that specifies the lower starting value for the binary search (default -10)
\item maxu: (u_find) A scalar or a named list that specifies the upper starting value for the binary search (default 10)
\item sampling_replace: (u_find) Logical, resampling with replacement? (default TRUE)
\item nonunique_jittersd: (u_find) Standard deviation of the noise to be added to the output (default NULL meaning no noise)
\item maxbatchs: (u_find, rejection) The maximum number of batches for rejection sampling (for discrete variables)
\item weightfunction: (u_find) A function or a named list of functions to be applied to dedicated error terms to obtain the resampling weights (default stats::dnorm)
}}
}
\value{
A data table representing the situation after the counterfactual intervention
}
\description{
Counterfactual inference via simulation
}
\examples{
cfdata <- counterfactual(backdoor,
                         situation = list(
                             do = list(target = "x", ifunction = 0),
                             condition = data.table::data.table( x = 0, y = 0)),
                         target = "x",
                         ifunction = 1,
                         method = "rejection",
                         n = 1000)
mean(cfdata$y)

backdoor_parallel <- ParallelWorld$new(backdoor,
                                       dolist=list(
                                         list(target = "x", ifunction = 0),
                                         list(target = list("z","x"), ifunction = list(1,0))
                                       )
)
cfdata2 <- counterfactual(backdoor_parallel,
                         situation = list(
                             do = NULL,
                             condition = data.table::data.table( y = 0, y_1 = 0, y_2 = 0)),
                         target = "x",
                         ifunction = 1,
                         method = "rejection",
                         n = 1000)
mean(cfdata2$y)
}
