% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StandUnitCube.R
\name{intervalize}
\alias{intervalize}
\title{Intervalizes the matrix given as input}
\usage{
intervalize(xx, a = -1, b = 1)
}
\arguments{
\item{xx}{Matrix or a data frame of numeric entries}

\item{a}{lower bound of the target interval}

\item{b}{upper bound of the target interval}
}
\value{
Matrix with columns that have minimum zero and maximum one
}
\description{
Intervalizes the matrix given as input
}
\examples{
\dontrun{
# I don't want you to run this
}
n<-450; x <- data.frame(cbind(rnorm(n, 162, 4), rnorm(n, 108, 2),
rnorm(n, 117, 3), rnorm(n, 36, 2), rnorm(n, 45, 2)))
p <- ncol(x)
x.inter <- intervalize(x,a=-1,b=1)
round(head(x),2)
round(head(x.inter),2)
round(rbind(apply(x, 2, min), apply(x.inter, 2, min)),2)
round(rbind(apply(x, 2, max),apply(x.inter, 2, max)),2)
oldpar<-par(mfrow=c(1,2))
boxplot(x[,1:min(5,p)], main='Original Data', col=rainbow(9))
boxplot(x.inter[,1:min(5,p)], main='PreProcessed Data', col=rainbow(7))
par(oldpar)
}
