% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blup.R
\name{blup}
\alias{blup}
\title{blup}
\usage{
blup(
  x,
  sample = NULL,
  year = NULL,
  loc = NULL,
  rep = NULL,
  phe = NULL,
  fold = 1.5
)
}
\arguments{
\item{x}{Input phenotype data file.}

\item{sample}{The column name of the sample name in phenotypic data. (Default: NULL)}

\item{year}{The column name of the year in phenotypic data. (Default: NULL)}

\item{loc}{The column name of the location in phenotypic data. (Default: NULL)}

\item{rep}{The column name of the replication in phenotypic data. (Default: NULL)}

\item{phe}{The column name of the phenotypic value in data. (Default: NULL)}

\item{fold}{Fold before inter-quartile range. (Default: 1.5)}
}
\value{
Estimate BLUPs for a phenotypic data with outliers removed on a per sample basis.
}
\description{
Performs the Best Linear Unbiased Prediction (BLUP)
}
\examples{
data("wheatds")
blup_out <- blup(wheatds, sample = "Line", loc = "Env", rep = "Rep", phe = "DS")
}
\author{
Peng Zhao <pengzhao@nwafu.edu.cn>
}
