% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{byX}
\alias{byX}
\title{Calls FUN on a subset of data in blocks of size 'subset_size' of unique indices.}
\usage{
byX(data, indices, subset_size = 5, FUN, sort_indices = TRUE, ...)
}
\arguments{
\item{data}{Data.frame whose subsets to use on FUN}

\item{indices}{Vector of group assignments, same length as nrow(data)}

\item{subset_size}{Number of groups to use in one subset}

\item{FUN}{Function applied to subsets of data}

\item{sort_indices}{Sort groups (by their sorted character(!) names) before building subsets}

\item{...}{More arguments to FUN}
}
\value{
list of function result (one entry for each subset)
}
\description{
One subset consists of 'subset_size' unique groups and thus of all rows which
in 'data' which have any of these groups.
The last subset might have less groups, if the number of unique groups is not dividable by subset_size.
}
\details{
FUN is applied on each subset.
}
\examples{
 byX(data.frame(d=1:10), 1:10, 2, sum)
 
}
