% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeGetTipsInRegime}
\alias{PCMTreeGetTipsInRegime}
\title{Get the tips belonging to a regime in a tree}
\usage{
PCMTreeGetTipsInRegime(tree, regime)
}
\arguments{
\item{tree}{a phylo object with an edge.regime member or a PCMTree object}

\item{regime}{a character or integer denoting a regime in the tree.}
}
\value{
an integer vector with the ids of the tips belonging to regime.
}
\description{
Get the tips belonging to a regime in a tree
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- ape::rtree(10)
regimes <- sample(letters[1:3], nrow(tree$edge), replace = TRUE)
PCMTreeSetRegimesForEdges(tree, regimes)

if(requireNamespace("ggtree"))
PCMTreePlot(tree) + ggtree::geom_nodelab() + ggtree::geom_tiplab()

regime <- PCMRegimes(tree)[1]
PCMTreeGetTipsInRegime(tree, regime)
print(regime)

}
\seealso{
\link{PCMTreeGetTipsInPart}, \link{PCMTreeGetPartNames}, \link{PCMRegimes}, \link{PCMTreeGetPartRegimes}, \link{PCMTreeSetPartRegimes}, \link{PCMTreeGetPartition}
}
