% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{Roacheggs}
\alias{Roacheggs}
\title{Oriental Cockroaches}
\format{
A data frame with 81 observations on the following variable:
\describe{ 
\item{eggs}{numeric vector where a 0 indicates nothing
hatched while a 1 indicates the birth of a cockroach.} 
}
}
\source{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\description{
A laboratory is interested in testing a new child friendly pesticide on
\emph{Blatta orientalis} (oriental cockroaches). Scientists apply the new
pesticide to 81 randomly selected Blatta orientalis oothecae (eggs).  The
results from the experiment are stored in the data frame \code{Roacheggs} in
the variable \code{eggs}.  A zero in the variable \code{eggs} indicates that
nothing hatched from the egg while a 1 indicates the birth of a cockroach.
Data is used in Example 7.16.
}
\examples{

p <- seq(0.1, 0.9, 0.001)
negloglike <- function(p){
-(sum(Roacheggs$eggs)*log(p) + sum(1 - Roacheggs$eggs)*log(1 - p))
}
nlm(negloglike, 0.2)
rm(negloglike)

}
\keyword{datasets}
