# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Dimensions of a `data.frame`
#' 
#' @description
#' Similar to base-R [nrow()], [ncol()] and [dim()], this set of functions 
#' let's you retrieve the number of rows and columns of a `data.frame`.
#' 
#' @param x A `data.frame`.
#' 
#' @return `dimC()` returns an `integer` vector of length 2 (number of rows and 
#' columns); `nrowC()` (or `ncolC()`) returns the number of rows (or columns) 
#' as a single `integer`.
#' 
#' @author
#' Florian Detsch
#' 
#' @name OrcsCppFun
#' 
#' @examples
#' dat <- data.frame(a = 1:4, b = 2:5, c = 3:6)
#' 
#' nrowC(dat)
#' 
#' 
#' 
NULL

#' @export nrowC
#' @aliases nrowC
#' @describeIn OrcsCppFun 
nrowC <- function(x) {
    .Call(`_Orcs_nrowC`, x)
}

#' @export ncolC
#' @aliases ncolC
#' @describeIn OrcsCppFun 
ncolC <- function(x) {
    .Call(`_Orcs_ncolC`, x)
}

#' @export dimC
#' @aliases dimC
#' @describeIn OrcsCppFun 
dimC <- function(x) {
    .Call(`_Orcs_dimC`, x)
}

#' Substrings of a Character Vector (C++ Style)
#' 
#' @description Extract substrings from a `character` vector in C++.
#' 
#' @param x A `character` vector.
#' @param pos The start point of the substring as `integer`. Position 
#'   indications start from `1L`, which is the default in R.
#' @param len The length of the substring as `integer`.
#' 
#' @return
#' A `character` vector of the same length as 'x'.
#' 
#' @seealso
#' <https://cplusplus.com/reference/string/string/substr/>, [substr()].
#' 
#' @examples
#' substrC("Hello, world!", pos = 1, len = 5)
#' 
#' @export
substrC <- function(x, pos, len) {
    .Call(`_Orcs_substrC`, x, pos, len)
}

