% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opl_tb_c.R
\name{opl_tb_c}
\alias{opl_tb_c}
\title{Threshold-based policy learning at specific values}
\usage{
opl_tb_c(make_cate_result, z, w, c1 = NA, c2 = NA, verbose = TRUE)
}
\arguments{
\item{make_cate_result}{A data frame containing the input data. It must include
a column named \code{my_cate} representing conditional average treatment effects (CATE) generated using make_cate function.}

\item{z}{A character vector of length 2 specifying the column names of the two
threshold variables to be standardized.}

\item{w}{A character string specifying the column name indicating treatment assignment (binary variable).}

\item{c1}{Threshold for var1 given by the user or optimized by the the function. This number must be chosen between 0 and 1.}

\item{c2}{Threshold for var2 given by the user or optimized by the the function. This number must be chosen between 0 and 1.}

\item{verbose}{Set TRUE to print the output on the console.}
}
\value{
The function invisibly returns the input data frame augmented with the following columns:
\itemize{
\item \code{z[1]_std}: Standardized version of the first threshold variable.
\item \code{z[2]_std}: Standardized version of the second threshold variable.
\item \code{units_to_be_treated}: Binary indicator for whether a unit should be treated based on the optimal policy.
}
Additionally, the function:
\itemize{
\item Prints the main results summary, including optimal threshold values, average constrained and unconstrained welfare, and treatment proportions.
\item Displays a scatter plot visualizing the policy assignment.
}
}
\description{
Implementing ex-ante treatment assignment using as policy class a threshold-based (or quadrant)
approach at specific threshold values c1 and c2 for respectively the selection variables var1 and var2.
}
\details{
The function:
\enumerate{
\item Standardizes the threshold variables to a 0-1 range.
\item Identifies the optimal thresholds based on grid search for maximizing constrained welfare.
\item Computes and displays key statistics, including average welfare measures and the percentage of treated units.
}
}
\references{
\itemize{
\item Athey, S., and Wager S. 2021. Policy Learning with Observational Data, Econometrica, 89, 1, 133–161.
\item Cerulli, G. 2021. Improving econometric prediction by machine learning, Applied Economics Letters, 28, 16, 1419-1425.
\item Cerulli, G. 2022. Optimal treatment assignment of a threshold-based policy: empirical protocol and related issues, Applied Economics Letters, DOI: 10.1080/13504851.2022.2032577.
\item Gareth, J., Witten, D., Hastie, D.T., Tibshirani, R. 2013. An Introduction to Statistical Learning : with Applications in R. New York, Springer.
\item Kitagawa, T., and A. Tetenov. 2018. Who Should Be Treated? Empirical Welfare Maximization Methods for Treatment Choice, Econometrica, 86, 2, 591–616.
}
}
